//=============================================================================
// PoliceChief
//=============================================================================
class PoliceChief2 extends PoliceChief;

Var ReleasePlace RPLL;
Var PoliceCrimeMon PCM;
Var PolicePrivateArea PPA;

function BeginPlay()
{
	local ReleasePlace RPL;
	local PoliceCrimeMon PCMM;
	local PolicePrivateArea PPAA;

	foreach AllActors(Class'PoliceCrimeMon',PCMM)
	{
		PCM=PCMM;
	}

	foreach AllActors(Class'ReleasePlace',RPL)
	{
		RPLL = RPL;
	}

	foreach AllActors(Class'PolicePrivateArea',PPAA)
	{
		PPA=PPAA;
	}

	Super.BeginPlay();
}

function TakeDamageBase(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType,
                        bool bPlayAnim)
{
	local int i;
	local TrainingPistol2 TP2;

	for (i=1; i<21; i++)
	{
		if(Human(instigatedBy) == PCM.PlayerCop[i])
		{
			instigatedBy.ClientMessage("|p2Police Chief: Come on. Cut that out.");
			return; //If player's already a cop, nvm. Stop here.
		}
	}

	if(Human(instigatedBy) == P)
	{
		Human(instigatedBy).ClientMessage("|p2Needless to say, you failed. You didn't even make it out of the van before messing up.");
		OnMessage = 0;
		SetTimer(0.0, false);
		P = None;
		instigatedBy.SetLocation(RPLL.Location);

		foreach AllActors(Class'TrainingPistol2',TP2)
		{
			if(TP2.Owner == instigatedBy)
			{
				TP2.Destroy();
			}
		}
	}
	else
	{
		Human(instigatedBy).ClientMessage("|p2Needless to say, you failed. You didn't even make it out of the van before messing up.");
		instigatedBy.SetLocation(RPLL.Location);

		foreach AllActors(Class'TrainingPistol2',TP2)
		{
			if(TP2.Owner == instigatedBy)
			{
				TP2.Destroy();
			}
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
	local int i;
	local TrainingPistol2 TP2;

	for (i=1; i<21; i++)
	{
		if(DeusExPlayer(Frobber) == PCM.PlayerCop[i])
		{
			DeusExPlayer(Frobber).ClientMessage("|p4Police Chief: Looks like you passed, so welcome to the team. You can find more information on your duties and some extra equipment here. Good luck.");
			DeusExPlayer(Frobber).SetLocation(PPA.Location);
			
			foreach AllActors(Class'TrainingPistol2',TP2)
			{
				if(TP2.Owner == Human(Frobber))
				{
					TP2.Destroy();
				}
			}

			return;
		}
	}

	if(P == None)
	{
		P=DeusExPlayer(Frobber);
		DeusExPlayer(Frobber).ClientMessage("|p4Police Chief: Alright. First, I'm going to brief you on your new equipment.");
		SetTimer(1.8, true);
		OnMessage = 0;
	}
	else
	{
		DeusExPlayer(Frobber).ClientMessage("|p4Police Chief: Sorry. I'm briefing "$P.PlayerReplicationInfo.PlayerName$" on the mission. Hold on.");
	}
}

function Timer()
{
	if(OnMessage == 0)
	{
		p.ClientMessage("|p4Police Chief: Your primary tool for detainment will be the baton. You can knock criminals unconscious with this easily. Once knocked out, they will be sent to jail.");
		SetTimer(3.8, true);
	}

	if(OnMessage == 1)
	{
		p.ClientMessage("|p4Police Chief: Your other tool will be the prod. It will stun the criminal for a short duration. Usually enough to get a few hits in with the baton.");
		SetTimer(5.0, true);
	}

	if(OnMessage == 2)
	{
		p.ClientMessage("|p4Police Chief: Finally, your pistol. Like the other tools, it's non lethal as it fires rubber rounds. We'd like to avoid using this if possible.");
	}

	if(OnMessage == 3)
	{
		P.ClientMessage("|p4Police Chief: As for your test ... there's a girl being harassed by two thugs in a small backstreet.");
	}

	if(OnMessage == 4)
	{
		P.ClientMessage("|p4Police Chief: Take out the thugs then return to the van. It's an easy job. Pick up your equipment to my right and get started.");
		OnMessage = 0;
		SetTimer(0.0, false);
		P = None;
	}
	
	OnMessage += 1;
}

function Tick(float deltaTime)
{
	// Keep turning towards the person we're speaking to
	if (P != None)
	{
		LookAtActor(P, true, true, true, 0, 0.5);
		LipSynch(deltaTime);

	}
}

defaultproperties
{
     Orders=Sitting
     NNAlliance=Criminal
     Alliance=Cop
     apply=false
     HealthHead=100
     HealthTorso=100
     HealthLegLeft=100
     HealthLegRight=100
     HealthArmLeft=100
     HealthArmRight=100
     Orders=Wandering
     WalkingSpeed=0.300000
     BaseAssHeight=-23.000000
     //AttitudeToPlayer=ATTITUDE_Hate
     walkAnimMult=1.200000
     GroundSpeed=200.000000
     WaterSpeed=240.000000
     AirSpeed=144.000000
     BaseEyeHeight=36.000000
     DrawType=DT_Mesh
     CarcassType=Class'DeusEx.CopCarcass'
     WalkingSpeed=0.296000
     walkAnimMult=0.750000
     GroundSpeed=200.000000
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.JockTex0'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.CopTex2'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.CopTex0'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.CopTex1'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex2'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="Cop"
     FamiliarName="Police Chief"
     UnfamiliarName="Police Chief"
}